async function specificInitialization(application) {
    /* :~/git/discretepdfsigner/versions/standAlone$ base64 ../../SampleDocument.pdf > SampleDocument.pdf.b64 */
    var base64Pdf = `JVBERi0xLjUKJbXtrvsKNCAwIG9iago8PCAvTGVuZ3RoIDUgMCBSCiAgIC9GaWx0ZXIgL0ZsYXRl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==`;

/*  var picture = `iVBORw0KGgoAAAANSUhEUgAAAEsAAABLCAYAAAA4TnrqAAAABGdBTUEAALGPC/xhBQAAACBjSFJN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`; */
    
    var pdfBytes = base64Decode(base64Pdf);

    let file = new File(
        [pdfBytes],
        'SampleDocument.pdf',
        {type: 'application/pdf'}
    );

    console.log('Document received from standAlone, ' + pdfBytes.length + ' bytes, converted from ' + base64Pdf.length + ' base64 digits '+ dateTimeShrt());
    await application.loadDocuments([file]);

    let titleS = document.title;
    titleS += dateShort(buildInfo.time);
    console.log('Document in standAlone ' + titleS + ' - '+ dateTimeShrt());
    document.title = titleS;
}